/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.admin.result;

import filenet.vw.api.VWSession;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.admin.result.VWAdminItemInList;
import filenet.vw.toolkit.admin.result.VWAdminUserListCellRenderer;
import filenet.vw.toolkit.admin.result.resources.VWResource;
import filenet.vw.toolkit.utils.VWCachedSecurityList;
import filenet.vw.toolkit.utils.VWUsersAndGroupsPanel;
import filenet.vw.toolkit.utils.table.VWParticipantItem;
import java.awt.Cursor;

public class VWAdminAddRemoveWflGroupsPanel
extends VWUsersAndGroupsPanel {
    public VWAdminAddRemoveWflGroupsPanel(VWSession vwSession) {
        super(vwSession);
        this.setAvailableItemName(VWResource.s_availableUsers);
        this.setSelectedItemName(VWResource.s_selectedUsers);
    }

    protected void initializeLists(VWAdminItemInList[] selectedItems) {
        Cursor currentCursor = this.getCursor();
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            this.retrieveUsersAndGroups();
            this.setListCellRenderer(new VWAdminUserListCellRenderer());
            super.initializeLists(this.m_availableParticipants, selectedItems);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        this.setCursor(currentCursor);
    }

    protected void retrieveUsersAndGroups() {
        try {
            if (this.m_vwSession == null) {
                return;
            }
            VWParticipantItem[] userGroupList = VWCachedSecurityList.getUsersAndGroupsParticipant(this.m_vwSession);
            if (userGroupList != null) {
                this.m_availableParticipants = new VWAdminItemInList[userGroupList.length];
                for (int i = 0; i < userGroupList.length; ++i) {
                    this.m_availableParticipants[i] = new VWAdminItemInList(userGroupList[i].getVWParticipant(), false);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected Object[] onRemoveItemsAction(Object[] items) {
        try {
            if (items != null) {
                for (int i = 0; i < items.length; ++i) {
                    if (!(items[i] instanceof VWAdminItemInList)) continue;
                    ((VWAdminItemInList)items[i]).setGrayedOut(false);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return items;
    }

    protected void onAddItemsAction(Object[] items) {
        try {
            if (items != null) {
                for (int i = 0; i < items.length; ++i) {
                    if (!(items[i] instanceof VWParticipantItem)) continue;
                    VWAdminItemInList item = new VWAdminItemInList(((VWParticipantItem)items[i]).getVWParticipant(), false);
                    items[i] = item;
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }
}

